<?php

namespace Wisebee\Resources;

use Carbon\Carbon;
use Wisebee\Wisebee;

class Resource
{
    /** @var Wisebee|null $wisebee */
    protected $wisebee;
    public $uriBase;

    /**
     * Resource constructor
     *
     * @param Wisebee|null $wisebee
     */
    public function __construct(Wisebee $wisebee = null)
    {
        $this->wisebee = $wisebee;
    }

    /**
     * Gets Wisebee error
     *
     * @return string|null
     */
    public function getWisebeeError(): ?string
    {
        if (empty($this->wisebee)) {
            return null;
        }
        return $this->wisebee->getError();
    }

    /**
     * Builds resource class object
     *
     * @param $object
     * @return $this
     */
    public function build($object): Resource
    {
        $vars = get_object_vars($object);
        foreach ($vars as $key => $value) {
            if ($key === 'created_at') {
                $value = Carbon::parse($value);
            }
            $this->$key = $value;
        }
        return $this;
    }
}