<?php

namespace Wisebee\Resources;

use Carbon\Carbon;
use Wisebee\API;
use Wisebee\Wisebee;

/**
 * Accessors
 *
 * @property int $id
 * @property int $rate_id
 * @property int $user_id
 * @property int $customer_id
 * @property int $created_by_id
 * @property int $assessment_id
 * @property int $specialty_id
 * @property int $bundle_id
 * @property Carbon $time_from
 * @property Carbon $time_to
 * @property string $consultation_date
 * @property string $status
 * @property int $length
 * @property int $cooldown
 * @property float $cost
 * @property string $public_key
 * @property bool $is_archive
 * @property string $comments
 * @property string $notes
 * @property Carbon $expires_at
 * @property Carbon $created_at
 *
 */
class Consultation extends Resource
{
    public $uriBase = 'consultations';

    protected static $datetimeFields = [
        'time_from',
        'time_to',
        'expires_at',
        'created_at',
    ];

    /**
     * Resource constructor
     *
     * @param Wisebee|null $wisebee
     */
    public function __construct(Wisebee $wisebee = null)
    {
        parent::__construct($wisebee);
    }

    /**
     * Builds resource class object
     *
     * @param $object
     * @return Resource
     */
    public function build($object): Resource
    {
        $vars = get_object_vars($object);
        foreach ($vars as $key => $value) {
            if (in_array($key, self::$datetimeFields)) {
                $value = Carbon::parse($value);
            }
            $this->$key = $value;
        }
        return $this;
    }
}