<?php

namespace Wisebee\Resources;

use Carbon\Carbon;
use Wisebee\API;
use Wisebee\Wisebee;

/**
 * Accessors
 *
 * @property int $id
 * @property int $customer_id
 * @property int $consultation_id
 * @property string $method
 * @property float $amount
 * @property string $currency
 * @property string $status
 * @property string $reference
 * @property Carbon $created_at
 *
 */
class Payment extends Resource
{
    public $uriBase = 'payments';

    public function __construct(Wisebee $wisebee = null)
    {
        parent::__construct($wisebee);
    }

    /**
     * Logs a refund transaction
     *
     * @param $id
     * @param array $params
     */
    public function refund($id, array $params)
    {
        $this->wisebee->customApiCall(API::METHOD_POST, $this->uriBase . '/actions/refund/' . $id, $params);
    }
}