<?php

namespace Wisebee\Resources;

use Carbon\Carbon;
use Wisebee\API;
use Wisebee\Wisebee;

/**
 * Accessors
 *
 * @property int $id
 * @property int $consultation_id
 * @property int $user_id
 * @property int $customer_id
 * @property int $inviter_id
 * @property string $status
 * @property string $email
 * @property string $firstname
 * @property string $lastname
 * @property string $type
 * @property string $notes
 * @property string $invitation_sent_at
 * @property Carbon $created_at
 *
 */
class Participant extends Resource
{
    public $uriBase = 'participants';

    /**
     * Resource constructor
     *
     * @param Wisebee|null $wisebee
     */
    public function __construct(Wisebee $wisebee = null)
    {
        parent::__construct($wisebee);
    }

    /**
     * Invites a participant
     *
     * @param $id
     */
    public function invite($id)
    {
        $this->wisebee->customApiCall(API::METHOD_POST, $this->uriBase . '/actions/invite/' . $id);
    }
}