<?php

namespace Wisebee\Resources;

use Carbon\Carbon;
use Wisebee\Wisebee;

/**
 * Accessors
 *
 * @property int $id
 * @property int $user_id
 * @property int $specialty_id
 * @property int $form_id
 * @property bool $is_enabled
 * @property Carbon $created_at
 *
 * @property User $user
 * @property Specialty $specialty
 *
 */
class UserSpecialty extends Resource
{
    public $uriBase = 'users-specialties';

    public function __construct(Wisebee $wisebee = null)
    {
        parent::__construct($wisebee);
    }

    /**
     * Builds resource class object
     *
     * @param $object
     * @return Resource
     */
    public function build($object): Resource
    {
        $vars = get_object_vars($object);
        foreach ($vars as $key => $value) {
            if ($key === 'created_at') {
                $value = Carbon::parse($value);
            } elseif ($key === 'user') {
                $value = (new User())->build($value);
            } elseif ($key === 'specialty') {
                $value = (new Specialty())->build($value);
            }
            $this->$key = $value;
        }
        return $this;
    }
}