<?php

namespace Wisebee\Resources;

use Wisebee\API;
use Wisebee\Wisebee;

/**
 * Accessors
 *
 * @property int $id
 * @property string $email
 * @property string $firstname
 * @property string $lastname
 * @property string $phone
 * @property string $bio
 * @property string $created_at
 *
 */
class User extends Resource
{
    public $uriBase = 'users';
    public $authToken;

    public function __construct(Wisebee $wisebee = null)
    {
        parent::__construct($wisebee);
    }

    /**
     * Logs in user. Returns Auth token that can be used to identify the user
     *
     * @param $id
     */
    public function login($id)
    {
        $data = $this->wisebee->customApiCall(API::METHOD_POST, $this->uriBase . '/actions/login/' . $id);
        $this->authToken = $data->authToken;
    }

    /**
     * Logs out the user. Resets the Auth token in Wisebee
     *
     * @param $id
     */
    public function logout($id)
    {
        $this->wisebee->customApiCall(API::METHOD_POST, $this->uriBase . '/actions/logout/' . $id);
    }
}