<?php

namespace OCP;

/**
 * Class OCP. Helper class which servers as a layer between API and Website
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 * @package OCP
 */
class OCP
{
    private $username = '';
    private $apiKey = '';
    private $post = [];

    public function __construct($username, $apiKey)
    {
        $this->username = $username;
        $this->apiKey = $apiKey;
    }

    public function setPost($post)
    {
        $this->post = $post;
    }

    /**
     * @param \Closure $callback
     * @return bool
     * @throws OCPException
     */
    public function book(\Closure $callback)
    {
        // We only go further if the action is 'book'
        if ($this->post['action'] !== 'book') {
            return false;
        }

        if (!$this->validateBooking()) {
            return false;
        }

        $callback($this->post['consultations']);
        return true;
    }

    /**
     * Makes a call to OCP server to confirm the request really came from there
     * Just uses the token and public key of the first consultations
     * to find if it exists in OCP database
     *
     * @return bool
     * @throws OCPException
     */
    public function validateBooking()
    {
        $api = new API($this->username, $this->apiKey);
        $api->setPostFields([
            'token' => $this->post['consultations'][0]['token'],
            'public_key' => $this->post['consultations'][0]['public_key'],
        ]);
        $api->call('booking/validate');

        return $api->getResultCode() === 200 && $api->getResponse() === 'OK';
    }

    /**
     * @param $data
     * @return bool
     * @throws OCPException
     */
    public function submitPayment($data)
    {
        $api = new API($this->username, $this->apiKey);
        $api->setPostFields($data);
        $api->call('booking/payment');
        return $api->getResultCode() === 200 && $api->getResponse() === 'OK';
    }
}